# Translation Files

This folder contains translation files for the travel booking application in multiple languages.

## Structure

- `languages.json` - Index file containing language mappings and metadata
- Individual language files (e.g., `en.json`, `ar.json`, `fr.json`, etc.)

## Languages Created

✅ **Completed translations (33 languages):**
1. Arabic (ar.json) - العربية (RTL)
2. Bulgarian (bg.json) - Български  
3. Catalan (ca.json) - Català
4. Czech (cs.json) - Čeština
5. Danish (da.json) - Dansk
6. German (de.json) - Deutsch
7. Greek (el.json) - Ελληνικά
8. English UK (en.json) - English (UK)
9. English US (en-us.json) - English (US)
10. Spanish (es.json) - Español
11. Spanish Argentina (es-ar.json) - Español (AR)
12. Spanish Mexico (es-mx.json) - Español (MX)
13. Finnish (fi.json) - Suomi
14. French (fr.json) - Français  
15. Hebrew (he.json) - עברית (RTL)
16. Hindi (hi.json) - हिन्दी
17. Hungarian (hu.json) - Magyar
18. Indonesian (id.json) - Bahasa Indonesia
19. Italian (it.json) - Italiano
20. Japanese (ja.json) - 日本語
21. Korean (ko.json) - 한국어
22. Latvian (lv.json) - Latviski
23. Dutch (nl.json) - Nederlands
24. Norwegian (no.json) - Norsk
25. Polish (pl.json) - Polski
26. Portuguese Portugal (pt.json) - Português (PT)
27. Portuguese Brazil (pt-br.json) - Português (BR)
28. Romanian (ro.json) - Română
29. Russian (ru.json) - Русский
30. Swedish (sv.json) - Svenska
31. Thai (th.json) - ภาษาไทย
32. Turkish (tr.json) - Türkçe
33. Ukrainian (uk.json) - Українська
34. Vietnamese (vi.json) - Tiếng Việt
35. Chinese Simplified (zh-cn.json) - 简体中文
36. Chinese Traditional (zh-tw.json) - 繁體中文

**Still need to create:**
- Estonian (et.json) - Eesti
- Croatian (hr.json) - Hrvatski  
- Lithuanian (lt.json) - Lietuvių
- Malay (ms.json) - Bahasa Malaysia
- Slovenian (sl.json) - Slovenščina
- Serbian (sr.json) - Srpski
- Slovak (sk.json) - Slovenčina
- Filipino (fil.json) - Filipino
- Icelandic (is.json) - Íslenska

## Translation Coverage

Each translation file includes the main interface elements:
- Language selection
- Navigation elements
- Hero sections
- Tour booking forms
- Customer reviews
- Authentication pages
- And other key UI components

## Usage

To use these translations in your application:

1. Load the appropriate language file based on user preference
2. Use the language keys to display localized text
3. Handle RTL languages (Arabic, Hebrew) with appropriate CSS styling

## Notes

- RTL (Right-to-Left) languages are marked in languages.json
- Some placeholder text (Lorem ipsum) is kept as-is for layout purposes
- Currency codes and certain technical terms are maintained in English
- Additional languages can be added following the same structure

## Extending Translations

To add more languages:
1. Create a new JSON file with the language code (e.g., `fr-ca.json` for French Canadian)
2. Translate all text strings while keeping the JSON structure
3. Add the language entry to `languages.json`
4. Test with your application's i18n system
